/*
 * Decompiled with CFR 0.152.
 */
package lykrast.defiledlands.common.entity.monster;

import javax.annotation.Nullable;
import lykrast.defiledlands.common.entity.IEntityDefiled;
import lykrast.defiledlands.common.entity.monster.EntitySlimeDefiled;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;

public class EntityHost
extends EntityMob
implements IEntityDefiled {
    public static final ResourceLocation LOOT = new ResourceLocation("defiledlands", "entities/host");
    protected int slimesRemaining;
    protected int slimesQueued;

    public EntityHost(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.6f, 1.7f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.27);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(5.0);
        this.slimesRemaining = (int)this.func_110138_aP();
    }

    public void func_70636_d() {
        this.spawnSlimes();
        super.func_70636_d();
    }

    public void func_70106_y() {
        this.queueSlimes(this.slimesRemaining);
        this.spawnSlimes();
        super.func_70106_y();
    }

    protected void queueSlimes(int nb) {
        if (this.slimesRemaining > 0) {
            int i = Math.min(nb, this.slimesRemaining);
            this.slimesRemaining -= i;
            this.slimesQueued += i;
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        boolean flag = super.func_70097_a(source, amount);
        if (flag) {
            this.queueSlimes((int)amount);
        }
        return flag;
    }

    protected void spawnSlimes() {
        while (this.slimesQueued >= 2) {
            int i = 1;
            if (this.slimesQueued > 8) {
                i = 2;
            }
            if (!this.field_70170_p.field_72995_K) {
                int k = this.slimesQueued / 2;
                float f = ((float)(k % 2) - 0.5f) * 0.5f;
                float f1 = ((float)(k / 2) - 0.5f) * 0.5f;
                EntitySlimeDefiled slime = new EntitySlimeDefiled(this.field_70170_p);
                if (this.func_104002_bU()) {
                    slime.func_110163_bv();
                }
                slime.func_70799_a(i, true);
                slime.func_70012_b(this.field_70165_t + (double)f, this.field_70163_u + 0.5, this.field_70161_v + (double)f1, this.field_70146_Z.nextFloat() * 360.0f, 0.0f);
                this.field_70170_p.func_72838_d((Entity)slime);
            }
            if (i == 1) {
                this.slimesQueued -= 2;
                continue;
            }
            this.slimesQueued -= i * 4;
        }
    }

    public EnumCreatureAttribute func_70668_bt() {
        return EnumCreatureAttribute.UNDEAD;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187939_hm;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74777_a("SlimesRemaining", (short)this.slimesRemaining);
        compound.func_74777_a("SlimesQueued", (short)this.slimesQueued);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("SlimesRemaining", 99)) {
            this.slimesRemaining = compound.func_74765_d("SlimesRemaining");
        }
        if (compound.func_150297_b("SlimesQueued", 99)) {
            this.slimesQueued = compound.func_74765_d("SlimesQueued");
        }
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return LOOT;
    }
}

